PY2_LIBRARY()

OWNER(g:mproto)

PEERDIR(
    contrib/python/dateutil
    contrib/python/dnspython
    contrib/python/PyYAML
    contrib/python/enum34
    contrib/python/pytest-allure-adaptor
    contrib/python/PyHamcrest
    contrib/python/psycopg2
    contrib/python/paramiko
    library/python/vault_client
    library/python/resource
    mail/contrib/backoff
    mail/contrib/python/exchangelib
)

PY_SRCS(
    auth_results_parser.py
    bigml.py
    blackbox.py
    cache.py
    exchange.py
    fids.py
    headers.py
    hint.py
    imap.py
    logger.py
    nwsmtp/http_client.py
    matchers/base.py
    matchers/delivery_check_over_exchange.py
    matchers/delivery_check_over_imap.py
    matchers/delivery.py
    matchers/delivery_route.py
    matchers/dkim_sign_matcher.py
    matchers/folders.py
    matchers/labels.py
    matchers/message_comparison.py
    matchers/response_matcher.py
    matchers/wait_matcher.py
    msgs_builder.py
    psql.py
    qloud_cluster_resolver.py
    random_generator.py
    received_header_parser.py
    resource_file.py
    settings.py
    sharpei.py
    smtp_send_tools.py
    ssh.py
    storage.py
    types.py
    users.py
    utils.py
    xdb/__init__.py
    xdb/queries.py
)

END()
