# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import base64
from collections import namedtuple

from lib.headers import Header
from lib.msgs_builder import build_plain_text_message
from lib.psql import find_mail_message_row_by_hdr_message_id
from lib.random_generator import get_random_string

RANDOM_PREFIX = get_random_string(10)
Scenario = namedtuple("Scenario", ["description", "message_infos"])

MessageInfo = namedtuple("MessageInfo",
                         ["subject", "references_header_value", "hint_header_value", "message_id_header_value"])


def create_test_msg(message_info, rcpt):
    headers = {Header.X_YANDEX_SPAM: "1",
               Header.MESSAGE_ID: "<" + RANDOM_PREFIX + "@" + get_random_string(10) + ">"}
    if message_info.subject is not None:
        headers[Header.SUBJECT] = message_info.subject
    if message_info.references_header_value is not None:
        headers[Header.REFERENCES] = message_info.references_header_value
    if message_info.message_id_header_value is not None:
        headers[Header.MESSAGE_ID] = message_info.message_id_header_value
    if message_info.hint_header_value is not None:
        headers[Header.X_YANDEX_HINT] = base64.encodestring(message_info.hint_header_value).strip()

    return build_plain_text_message(from_email="mx-test-user20@ya.ru", to_emails=rcpt,
                                    text=RANDOM_PREFIX + " text_of_letter_was_here.",
                                    headers=headers)


def find_tid_for_user(user, message_id):
    mail_messages_table_record = find_mail_message_row_by_hdr_message_id(user.uid, message_id)
    if mail_messages_table_record is None:
        return None
    return mail_messages_table_record.found_tid


LABEL_PREFIX = "label="
LJ_LABEL_HINT_INFO = LABEL_PREFIX + "domain_vtnrf0livejournal"
JIRA_LABEL_HINT_INFO = LABEL_PREFIX + "domain_vtnrf0jira"
JIRA_LABEL_2_HINT_INFO = LABEL_PREFIX + "domain_vtnrf0jira\nimaplabel=IMAP_LABEL"
SYS_LABEL_1_HINT_INFO = LABEL_PREFIX + "domain_vtnrf0yadisk"
SYS_LABEL_2_HINT_INFO = LABEL_PREFIX + "domain_vtnrf0yasupport"
NO_SYS_LABEL_HINT_INFO = LABEL_PREFIX + "vnvbnbvnbvnbv"

YARU_LABEL_HINT_INFO = LABEL_PREFIX + "domain_yaru"

LABEL_MEDIA = "label=SystMetkaSO:s_media"
LABEL_AVIA = "label=SystMetkaSO:s_aviaeticket"
LABEL_ETICKET = "label=SystMetkaSO:eticket"
LABEL_LIVEMAIL = "label=SystMetkaSO:livemail"
LABEL_TRAVEL = "label=SystMetkaSO:s_travel"
LABEL_HOTEL = "label=SystMetkaSO:hotel"
LABEL_CANCEL = "label=SystMetkaSO:cancel"
LABEL_BOUNCE = "label=SystMetkaSO:bounce"

LABEL_NEWS = "label=SystMetkaSO:news"
LABEL_GR = "label=SystMetkaSO:s_grouponsite"
LABEL_DATING = "label=SystMetkaSO:s_datingsite"
USER_LABEL = "label=someMyLabel"

GROUPON_HINT_INFO = LABEL_NEWS + "\n" + LABEL_GR
GROUPON_HINT_INFO_2 = GROUPON_HINT_INFO + "\n" + LABEL_DATING
GROUPON_HINT_INFO_3 = LABEL_DATING + "\n" + GROUPON_HINT_INFO + "\n" + SYS_LABEL_1_HINT_INFO
NO_GROUPON_HINT_INFO_1 = LABEL_DATING + "\n" + LABEL_NEWS
NO_GROUPON_HINT_INFO_2 = LABEL_DATING + "\n" + LABEL_GR
NO_GROUPON_HINT_INFO_3 = LABEL_GR + "\n" + LABEL_DATING

TICKET_MEDIA_HINT_INFO = LABEL_MEDIA + "\n" + LABEL_ETICKET
TICKET_MEDIA_HINT_INFO_2 = LABEL_MEDIA + "\n" + LABEL_ETICKET + "\n" + LABEL_NEWS
TICKET_MEDIA_HINT_INFO_3 = LABEL_MEDIA + "\n" + LABEL_ETICKET + "\n" + LABEL_LIVEMAIL
TICKET_MEDIA_HINT_INFO_4 = LABEL_MEDIA + "\n" + LABEL_ETICKET + "\n" + GROUPON_HINT_INFO

LIVEMAIL_HINT_INFO = LABEL_LIVEMAIL + "\n"
LIVEMAIL_HINT_INFO_2 = LABEL_LIVEMAIL + "\n" + LABEL_ETICKET + "\n" + USER_LABEL
LIVEMAIL_HINT_INFO_3 = LABEL_LIVEMAIL + "\n" + LABEL_ETICKET + "\n" + LABEL_MEDIA

TICKET_HINT_INFO = LABEL_AVIA + "\n" + LABEL_ETICKET
TICKET_HINT_INFO_2 = LABEL_AVIA + "\n" + LABEL_ETICKET + "\n" + LABEL_LIVEMAIL
HOTEL_HINT_INFO = LABEL_HOTEL + "\n" + LABEL_TRAVEL
HOTEL_HINT_INFO_2 = LABEL_HOTEL + "\n" + LABEL_TRAVEL + "\n" + LABEL_LIVEMAIL
HOTEL_CANCEL_HINT_INFO = LABEL_CANCEL + "\n" + LABEL_TRAVEL
HOTEL_CANCEL_HINT_INFO_2 = LABEL_CANCEL + "\n" + LABEL_TRAVEL + "\n" + LABEL_LIVEMAIL
BOUNCE_HINT_INFO = LABEL_BOUNCE + "\n"
BOUNCE_HINT_INFO_2 = LABEL_BOUNCE + "\n" + LABEL_TRAVEL + "\n" + LABEL_LIVEMAIL

JIRA_LABEL_AND_GROUPON_HINT_INFO = JIRA_LABEL_HINT_INFO + "\n" + GROUPON_HINT_INFO
