package ru.yandex.mail.autouser.commands;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Sergey Galyamichev
 */
public class DeleteCommand extends RepeatableCommand {
    private final long stalePeriod;

    public DeleteCommand(long stalePeriod, long repeatInterval) {
        super(repeatInterval);
        this.stalePeriod = stalePeriod;
    }

    @JsonCreator
    protected DeleteCommand(
            @JsonProperty("id") String id,
            @JsonProperty("repeatInterval") long repeatInterval,
            @JsonProperty("stalePeriod") long stalePeriod
    ) {
        super(id, repeatInterval);
        this.stalePeriod = stalePeriod;
    }

    @Override
    public void accept(@Nonnull CommandVisitor visitor) {
        visitor.visit(this);
    }

    public long getStalePeriod() {
        return stalePeriod;
    }
}
