package ru.yandex.mail.autouser.commands;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

/**
 * schedule
 * commands :
 *      send email "to" and "what"
 *      reply "to"
 *      delete (older than)
 *      email list
 *
 * @author Sergey Galyamichev
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type")
@JsonSubTypes({
        @JsonSubTypes.Type(value = SendTextCommand.class, name = "SEND_TEXT"),
        @JsonSubTypes.Type(value = SendCommandCommand.class, name = "SEND_COMMAND"),
        @JsonSubTypes.Type(value = ReplyToCommand.class, name = "REPLY_TO"),
        @JsonSubTypes.Type(value = DeleteCommand.class, name = "DELETE"),
        @JsonSubTypes.Type(value = DeleteAllCommand.class, name = "DELETE_ALL"),
        @JsonSubTypes.Type(value = StopCommand.class, name = "STOP"),
        @JsonSubTypes.Type(value = RepeatCommand.class, name = "REPEAT"),
        @JsonSubTypes.Type(value = SendTextCommand.class, name = "SEND")
})
public abstract class EmailCommand {
    private final String id;

    protected EmailCommand(String id) {
        this.id = id;
    }

    protected EmailCommand() {
        this(UUID.randomUUID().toString());
    }

    public String getId() {
        return id;
    }

    public abstract void accept(@Nonnull CommandVisitor visitor);

    @Override
    public String toString() {
        return "EmailCommand{type=" + getClass().getName() + ", id=" + id + '}';
    }
}


