package ru.yandex.mail.autouser.commands;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Sergey Galyamichev
 */
public class EmailListCommand extends RepeatableCommand {
    public EmailListCommand(long repeatInterval) {
        super(repeatInterval);
    }

    @JsonCreator
    protected EmailListCommand(
            @JsonProperty("id") String id,
            @JsonProperty("repeatInterval") long repeatInterval
    ) {
        super(id, repeatInterval);
    }

    @Override
    public void accept(@Nonnull CommandVisitor visitor) {
        visitor.visit(this);
    }
}
