package ru.yandex.mail.autouser.commands;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Sergey Galyamichev
 */
public class RepeatCommand extends RepeatableCommand {
    private final EmailCommand subCommand;

    public RepeatCommand(long repeatInterval, EmailCommand subCommand) {
        super(repeatInterval);
        this.subCommand = subCommand;
    }

    @JsonCreator
    protected RepeatCommand(
            @JsonProperty("id") String id,
            @JsonProperty("repeatInterval") long repeatInterval,
            @JsonProperty("subCommand") EmailCommand subCommand) {
        super(id, repeatInterval);
        this.subCommand = subCommand;
    }

    public EmailCommand getSubCommand() {
        return subCommand;
    }

    @Override
    public void accept(@Nonnull CommandVisitor visitor) {
        visitor.visit(this);
    }
}
