package ru.yandex.mail.autouser.commands;

/**
 * @author Sergey Galyamichev
 */
public abstract class RepeatableCommand extends EmailCommand {
    private final long repeatInterval;

    public RepeatableCommand(long repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    protected RepeatableCommand(String id, long repeatInterval) {
        super(id);
        this.repeatInterval = repeatInterval;
    }

    public long getRepeatInterval() {
        return repeatInterval;
    }
}
