package ru.yandex.mail.autouser.commands;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Sergey Galyamichev
 */
public class ReplyToCommand extends RepeatableCommand {
    private final String address;

    public ReplyToCommand(String address, long repeatInterval) {
        super(repeatInterval);
        this.address = address;
    }

    @JsonCreator
    protected ReplyToCommand(
            @JsonProperty("id") String id,
            @JsonProperty("address") String address,
            @JsonProperty("repeatInterval") long repeatInterval
    ) {
        super(id, repeatInterval);
        this.address = address;
    }

    public String getAddress() {
        return address;
    }

    @Override
    public void accept(@Nonnull CommandVisitor visitor) {
        visitor.visit(this);
    }
}
