package ru.yandex.mail.autouser.commands;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Sergey Galyamichev
 */
public class SendCommandCommand extends SendCommand {
    private final EmailCommand subCommand;

    public SendCommandCommand(String addressee, EmailCommand subCommand) {
        super(addressee);
        this.subCommand = subCommand;
    }

    @JsonCreator
    protected SendCommandCommand(
            @JsonProperty("id") String id,
            @JsonProperty("addressee") String addressee,
            @JsonProperty("subCommand") EmailCommand subCommand) {
        super(id, addressee);
        this.subCommand = subCommand;
    }

    public EmailCommand getSubCommand() {
        return subCommand;
    }

    @Override
    public void accept(@Nonnull CommandVisitor visitor) {
        visitor.visit(this);
    }
}
