package ru.yandex.mail.autouser.commands;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Sergey Galyamichev
 */
public class SendTextCommand extends SendCommand {
    private final String text;
    private final String subject;

    public SendTextCommand(String addressee, String subject, String text) {
        super(addressee);
        this.text = text;
        this.subject = subject;
    }

    @JsonCreator
    protected SendTextCommand(
            @JsonProperty("id") String id,
            @JsonProperty("addressee") String addressee,
            @JsonProperty("text") String text,
            @JsonProperty("subject") String subject) {
        super(id, addressee);
        this.text = text;
        this.subject = subject;
    }

    public String getText() {
        return text;
    }

    public String getSubject() {
        return subject;
    }

    @Override
    public void accept(@Nonnull CommandVisitor visitor) {
        visitor.visit(this);
    }
}
