package ru.yandex.mail.autouser.service;

import java.util.List;

import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import ru.yandex.mail.autouser.commands.EmailCommand;

/**
 * @author Sergey Galyamichev
 */
@Path("executor")
@Consumes(MediaType.APPLICATION_JSON)
@Produces(MediaType.APPLICATION_JSON)
public interface CommandService {
    @GET
    @Path("list")
    List<String> list();

    @POST
    @Path("run")
    String run(@Nonnull EmailCommand command);

    @POST
    @Path("stop")
    String stop(@Nonnull String id);

    @POST
    @Path("ping")
    String ping(@Nonnull String nickname);
}
