package ru.yandex.mail.autouser.cron;

import javax.inject.Inject;
import javax.mail.Message;
import javax.mail.MessagingException;

import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import ru.yandex.mail.autouser.mail.ImapService;

/**
 * @author Sergey Galyamichev
 */
@Component
public class ReportingJob implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(ReportingJob.class);

    @Inject
    private HeartbeatMessageProcessor heartbeatMessageProcessor;
    @Inject
    private ImapService imapService;

    public synchronized void execute(JobExecutionContext context) {
        try {
            imapService.forEach(ImapService.NOT_SEEN, this::process);
        } catch (MessagingException e) {
            LOG.error("Something goes wrong!", e);
        }
    }

    private void process(Message message) throws MessagingException {
        heartbeatMessageProcessor.doProcess(message);
        ImapService.markDelete(message);
    }
}
