package ru.yandex.mail.autouser.cron;

import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;

import ru.yandex.qe.scheduler.AutowiringSpringBeanJobFactory;

@Configuration
public class ScheduleSpring {
    private final ApplicationContext applicationContext;
    private final String reportExpression;
    private final String sendExpression;

    public ScheduleSpring(ApplicationContext applicationContext,
                          @Value("${scenario.cron.expression}") String reportExpression,
                          @Value("${scenario.cron.expression}") String sendExpression) {
        this.applicationContext = applicationContext;
        this.reportExpression = reportExpression;
        this.sendExpression = sendExpression;
    }

    @Bean
    public JobDetailFactoryBean heartbeatDetails() {
        JobDetailFactoryBean jobDetailFactory = new JobDetailFactoryBean();
        jobDetailFactory.setBeanName("CronTask");
        jobDetailFactory.setName("mail-heartbeat");
        jobDetailFactory.setJobClass(HeartbeatJob.class);
        jobDetailFactory.setDurability(true);
        return jobDetailFactory;
    }

    @Bean
    public JobDetailFactoryBean reportDetail() {
        JobDetailFactoryBean jobDetailFactory = new JobDetailFactoryBean();
        jobDetailFactory.setBeanName("CronTask");
        jobDetailFactory.setName("mail-reporter");
        jobDetailFactory.setJobClass(ReportingJob.class);
        jobDetailFactory.setDurability(true);
        return jobDetailFactory;
    }

    @Bean(name="reportTrigger")
    public CronTriggerFactoryBean reportTrigger(JobDetail reportDetail) {
        CronTriggerFactoryBean trigger = new CronTriggerFactoryBean();
        trigger.setJobDetail(reportDetail);
        trigger.setCronExpression(reportExpression);
        return trigger;
    }

    @Bean(name="sendTrigger")
    public CronTriggerFactoryBean sendTrigger(JobDetail heartbeatDetails) {
        CronTriggerFactoryBean trigger = new CronTriggerFactoryBean();
        trigger.setJobDetail(heartbeatDetails);
        trigger.setCronExpression(sendExpression);
        return trigger;
    }

    @Bean
    public SchedulerFactoryBean scheduler(Trigger reportTrigger, Trigger sendTrigger) {
        SchedulerFactoryBean schedulerFactory = new SchedulerFactoryBean();
        schedulerFactory.setConfigLocation(new ClassPathResource("properties/quartz.properties"));
        schedulerFactory.setJobFactory(springBeanJobFactory());
        schedulerFactory.setTriggers(reportTrigger, sendTrigger);
        return schedulerFactory;
    }

    @Bean
    public SpringBeanJobFactory springBeanJobFactory() {
        AutowiringSpringBeanJobFactory jobFactory = new AutowiringSpringBeanJobFactory();
        jobFactory.setApplicationContext(applicationContext);
        return jobFactory;
    }
}
