package ru.yandex.mail.autouser.service;

import java.util.List;

import javax.annotation.Nonnull;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import ru.yandex.mail.autouser.commands.CommandExecutor;
import ru.yandex.mail.autouser.commands.EmailCommand;

/**
 * @author Sergey Galyamichev
 */
@Service("commandService")
public class CommandServiceImpl implements CommandService {
    private static final Logger LOG = LoggerFactory.getLogger(CommandServiceImpl.class);

    private final CommandExecutor commandExecutor;
    private final AgentList agentList;

    public CommandServiceImpl(CommandExecutor commandExecutor, AgentList agentList) {
        this.commandExecutor = commandExecutor;
        this.agentList = agentList;
    }

    @Override
    public List<String> list() {
        LOG.debug("In list()...");
        return commandExecutor.commandsList();
    }

    @Override
    public String run(@Nonnull EmailCommand command) {
        LOG.debug("In run(command = [" + command + "])...");
        command.accept(commandExecutor);
        return "OK";
    }

    @Override
    public String stop(@Nonnull String id) {
        LOG.debug("In stop(id = [" + id + "])...");
        return commandExecutor.stop(id) ? "OK" : "Failed";
    }

    @Override
    public String ping(@Nonnull String nickname) {
        LOG.debug("In ping(nickname = [" + nickname + "])...");
        return  agentList.gotPing(nickname);
    }
}
