package ru.yandex.mail.autouser.bond.cron;

import javax.mail.Message;
import javax.mail.MessagingException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import ru.yandex.mail.autouser.mail.SmtpService;
import ru.yandex.mail.autouser.reports.HeartbeatReport;
import ru.yandex.mail.autouser.utils.MessageHeaders;
import ru.yandex.mail.autouser.utils.MessageHelper;

/**
 * @author Sergey Galyamichev
 */
@Component
public class HeartbeatProcessor {
    private final static ObjectMapper OM = new ObjectMapper();

    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatProcessor.class);

    private final SmtpService smtpService;

    public HeartbeatProcessor(SmtpService smtpService) {
        this.smtpService = smtpService;
    }

    public void process(Message message) throws MessagingException {
        try {
            LOG.debug("In doHeartbeatActions(Message message[id={}])...",
                    String.join(" ", message.getHeader(MessageHeaders.MESSAGE_ID)));
            LOG.info("sentDate={}, receiveDate={}, X-Yandex-TimeMark={}", message.getReceivedDate().getTime(),
                    message.getReceivedDate().getTime(), String.join(",", message.getHeader("X-Yandex-TimeMark")));
            String report = OM.writeValueAsString(new HeartbeatReport(MessageHelper.getDeliveryTime(message)));
            smtpService.reply(message, null, report);
            LOG.debug("Reply to heartbeat #{}", message.getSubject().substring(message.getSubject().indexOf("#") + 1));
        } catch (JsonProcessingException e) {
            LOG.error("Very strange exception...", e);
        }
    }
}
