package ru.yandex.mail.autouser.bond.cron;

import javax.inject.Inject;
import javax.mail.Message;
import javax.mail.MessagingException;

import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.mail.autouser.commands.CommandConverter;
import ru.yandex.mail.autouser.commands.CommandExecutor;
import ru.yandex.mail.autouser.commands.EmailCommand;
import ru.yandex.mail.autouser.mail.ImapService;
import ru.yandex.mail.autouser.mail.SmtpService;
import ru.yandex.mail.autouser.service.CommandService;
import ru.yandex.mail.autouser.utils.MessageHelper;
import ru.yandex.mail.autouser.utils.MessageTypes;

/**
 * @author Sergey Galyamichev
 */
public class ScanInbox implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(ScanInbox.class);
    @Inject
    private HeartbeatProcessor heartbeatMessageProcessor;
    @Inject
    private ImapService imapService;
    @Inject
    private CommandExecutor commandExecutor;
    @Inject
    private CommandService commandService;
    @Inject
    private SmtpService smtpService;

    public synchronized void execute(JobExecutionContext context) {
        try {
            imapService.forEach(ImapService.NOT_SEEN, this::process);
        } catch (Exception e) {
            LOG.error("Something goes wrong", e);
        } finally {
            try {
                commandService.ping(smtpService.getAddress().toString());
            } catch (MessagingException e) {
                LOG.error("Ping failed", e);
            }
        }
    }

    private void process(Message message) throws MessagingException {
        MessageTypes type = MessageHelper.getTypeBySubject(message);
        if (type == MessageTypes.HEARTBEAT) {
            heartbeatMessageProcessor.process(message);
        } else if (type == MessageTypes.COMMAND) {
            try {
                String content = MessageHelper.getTextFromMessage(message);
                LOG.debug("Command {}", message.getSubject());
                CommandConverter.fromString(content, EmailCommand.class).accept(commandExecutor);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        ImapService.markDelete(message);
    }
}
