package ru.yandex.mail.autouser.commands;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

public class CommandConverter {
    private final static ObjectMapper OM = new ObjectMapper();

    public static <T> T fromString(String command, Class<T> clazz) throws Exception {
        return OM.readValue(command, clazz);
    }

    public static <T> T fromSafeString(String command, Class<T> clazz) {
        try {
            return OM.readValue(command, clazz);
        } catch (IOException e) {
            return null;
        }
    }

    public static <T> String toString(T command) throws Exception {
        return OM.writeValueAsString(command);
    }

    public static <T> String toSafeString(T command) {
        try {
            return OM.writeValueAsString(command);
        } catch (JsonProcessingException e) {
            return "Error";
        }
    }
}
