package ru.yandex.mail.autouser.commands;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author Sergey Galyamichev
 */
@Configuration
public class EmailScheduler {
    private static final String EMAIL_SCHEDULER_THREAD = "EmailScheduleThread #";
    private static final AtomicInteger counter = new AtomicInteger();
    private final int poolSize = 5;

    @Bean
    public ScheduledExecutorService scheduledExecutor() {
        return new ScheduledThreadPoolExecutor(poolSize, this::newThread);
    }

    private Thread newThread(Runnable r) {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName(EMAIL_SCHEDULER_THREAD + counter.getAndIncrement());
        return t;
    }
}
