package ru.yandex.mail.autouser.mail;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.springframework.stereotype.Component;

import ru.yandex.mail.autouser.utils.MessageHeaders;

/**
 * @author Sergey Galyamichev
 */
@Component
public class SmtpService {
    private static final Logger LOG = LoggerFactory.getLogger(SmtpService.class);

    private final JavaMailSender javaMailSender;
    private final String nickname;
    private final String username;

    @Autowired
    public SmtpService(JavaMailSender javaMailSender,
                       @Value("${yandex.nickname}") String nickname,
                       @Value("${yandex.username}") String username) {
        this.javaMailSender = javaMailSender;
        this.nickname = nickname;
        this.username = username;
    }

    public void updateFrom(MimeMessageHelper message) throws MessagingException {
        message.setFrom(getAddress());
    }

    public void updateFrom(MimeMessage message) throws MessagingException {
        message.setFrom(getAddress());
    }

    public InternetAddress getAddress() throws MessagingException {
        return MessageHeaders.buildAddress(nickname, username);
    }

    public void send(MimeMessagePreparator mimeMessagePreparator) {
        javaMailSender.send(mimeMessagePreparator);
    }

    public void send(MimeMessage mimeMessage) {
        javaMailSender.send(mimeMessage);
    }

    public void reply(Message message, String address, String text) throws MessagingException {
        MimeMessage replyMessage = (MimeMessage) message.reply(false);
        updateFrom(replyMessage);
        LOG.debug("Time marks are {}", String.join(" ", message.getHeader(MessageHeaders.X_YANDEX_TIME_MARK)));
        replyMessage.setText(text);
        replyMessage.setReplyTo(address == null ? message.getReplyTo() : new Address[] {new InternetAddress(address)});
        send(replyMessage);
    }
}
