package ru.yandex.mail.autouser.tasks;

import javax.mail.Message;
import javax.mail.MessagingException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.mail.autouser.mail.ImapService;

/**
 * @author Sergey Galyamichev
 */
public class DeleteStaleEmailsTask implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteStaleEmailsTask.class);

    private final ImapService imapService;
    private final long stalePeriod;

    public DeleteStaleEmailsTask(ImapService imapService, long stalePeriod) {
        this.imapService = imapService;
        this.stalePeriod = stalePeriod;
    }

    @Override
    public void run() {
        try {
            imapService.forEach(this::isStale, ImapService::markDelete);
            int count = imapService.expunge();
            if (count > 0) {
                LOG.info("{} emails deleted", count);
            }
        } catch (MessagingException e) {
            LOG.error("Unable to delete stale emails", e);
        }
    }

    private boolean isStale(Message message) throws MessagingException {
        return message.getReceivedDate().getTime() + stalePeriod < System.currentTimeMillis();
    }
}
