package ru.yandex.mail.autouser.tasks;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.mail.autouser.mail.ImapService;
import ru.yandex.mail.autouser.mail.SmtpService;

/**
 * @author Sergey Galyamichev
 */
public class ListSizeReportingTask implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ListSizeReportingTask.class);

    private final ImapService imapService;
    private final SmtpService smtpService;

    public ListSizeReportingTask(ImapService imapService, SmtpService smtpService) {
        this.imapService = imapService;
        this.smtpService = smtpService;
    }

    @Override
    public void run() {
        try {
            imapService.login();
            smtpService.send(m -> buildReportEmail(m, imapService.getMessageCount()));
            imapService.logout();
        } catch (MessagingException e) {
            LOG.error("Unable to process email list", e);
        }
    }

    private void buildReportEmail(MimeMessage message, int messageCount) {

    }
}
