package ru.yandex.mail.autouser.tasks;

import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.mail.autouser.mail.EmailProcessor;
import ru.yandex.mail.autouser.mail.ImapService;
import ru.yandex.mail.autouser.mail.SmtpService;
import ru.yandex.mail.autouser.utils.MessageHeaders;

/**
 * @author Sergey Galyamichev
 */
public class ReplyTask implements Runnable, EmailProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ReplyTask.class);
    private final String address;
    private final ImapService imapService;
    private final SmtpService smtpService;

    public ReplyTask(ImapService imapService, SmtpService smtpService, String address) {
        this.address = address;
        this.imapService = imapService;
        this.smtpService = smtpService;
    }

    @Override
    public void run() {
        try {
            imapService.forEach(ImapService.NOT_SEEN, this);
        } catch (MessagingException e) {
            LOG.error("Unable to process messages", e);
        }
    }

    public void onEmailReceived(Message message) throws MessagingException {
        LOG.debug("process(Message message[id={}])...",
                String.join(" ", message.getHeader(MessageHeaders.MESSAGE_ID)));
        smtpService.reply(message, address, "");
        message.setFlag(Flags.Flag.SEEN, true);
        LOG.debug("Reply to heartbeat #{}", message.getSubject().substring(message.getSubject().indexOf("#") + 1));
    }
}
