package ru.yandex.mail.autouser.tasks;

import ru.yandex.mail.autouser.commands.CommandExecutor;
import ru.yandex.mail.autouser.commands.EmailCommand;

/**
 * @author Sergey Galyamichev
 */
public class RunCommandTask implements Runnable{
    private final CommandExecutor commandExecutor;
    private final EmailCommand command;

    public RunCommandTask(CommandExecutor commandExecutor, EmailCommand command) {
        this.commandExecutor = commandExecutor;
        this.command = command;
    }

    @Override
    public void run() {
        command.accept(commandExecutor);
    }
}
