package ru.yandex.mail.autouser.utils;

import java.io.UnsupportedEncodingException;

import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;

/**
 * @author Sergey Galyamichev
 */
public class MessageHeaders {
    public static final String MESSAGE_ID = "Message-ID";
    public static final String X_YANDEX_TIME_MARK = "X-Yandex-TimeMark";


    public static final String AT_YANDEX_RU = "@yandex.ru";

    public static InternetAddress buildAddress(String nickname, String username) throws MessagingException {
        try {
            return new InternetAddress(username + AT_YANDEX_RU, nickname);
        } catch (UnsupportedEncodingException e) {
            throw new MessagingException("Unable to build address", e);
        }
    }

}
