package ru.yandex.mail.autouser.utils;

import java.io.IOException;

import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;

/**
 * @author Sergey Galyamichev
 */
public class MessageHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MessageHelper.class);

    public static MessageTypes getTypeBySubject(Message message) throws MessagingException {
        String subject = message.getSubject();
        if (subject != null) {
            for (MessageTypes type: MessageTypes.values()) {
                if (subject.contains(type.getPrettyName())) {
                    return type;
                }
            }
        }
        return MessageTypes.UNKNOWN;
    }

    public static long getDeliveryTime(Message message) throws MessagingException {
        return message.getReceivedDate().getTime() - message.getSentDate().getTime();
    }

    public static String getTextFromMessage(Message message) throws MessagingException {
        try {
            if (message.isMimeType(MediaType.TEXT_PLAIN_VALUE)) {
                return message.getContent().toString();
            } else if (message.isMimeType("multipart/*")) {
                return getTextFromMimeMultipart((MimeMultipart) message.getContent());
            }
            return null;
        } catch (IOException e) {
            throw new MessagingException("Unable to get content", e);
        }
    }

    private static String getTextFromMimeMultipart(MimeMultipart mimeMultipart) throws MessagingException, IOException {
        String result = "";
        int count = mimeMultipart.getCount();
        for (int i = 0; i < count; i++) {
            BodyPart bodyPart = mimeMultipart.getBodyPart(i);
            if (bodyPart.isMimeType(MediaType.TEXT_PLAIN_VALUE)) {
                result = result + "\n" + bodyPart.getContent();
                break;
            } else if (bodyPart.isMimeType(MediaType.TEXT_HTML_VALUE)) {
                String html = (String) bodyPart.getContent();
                result = result + "\n" + html;
            } else if (bodyPart.getContent() instanceof MimeMultipart) {
                result = result + getTextFromMimeMultipart((MimeMultipart) bodyPart.getContent());
            }
        }
        return result;
    }
}
