#include "convert.h"

#include <langdetect/strings.hpp>


namespace NNodejs {

using namespace std::string_literals;

Napi::Object box(Napi::Env env, const langdetect::langinfo& info) {
    Napi::Object retval = Napi::Object::New(env);
    retval.Set("id", info.code);
    retval.Set("name", info.name);

    return retval;
}

Napi::Object box(Napi::Env env, const langdetect::find_domain_result& result) {
    Napi::Object retval = Napi::Object::New(env);
    retval.Set("host", result.domain);
    retval.Set("changed", result.found);
    retval.Set("content-region", result.content_region);

    return retval;
}

FindParams::FindParams(const Napi::Object& object) {
    Napi::Array headerNames = object.GetPropertyNames();

    for (uint32_t index = 0; index < headerNames.Length(); ++index) {
        Napi::String headerName = headerNames.Get(index).As<Napi::String>();

        if (!headerName.IsString()) {
            continue;
        }

        std::string name = headerName.Utf8Value();

        if (name == langdetect::strings::PARAM_COOKIE) {
            int32_t cookieLang;
            Napi::Value headerValue = object.Get(headerName);
            if (headerValue.IsString()) {
                cookieLang = std::stoi(headerValue.As<Napi::String>().Utf8Value());
            }
            if (headerValue.IsNumber()) {
                cookieLang = headerValue.As<Napi::Number>().Int32Value();
            }

            if (!userInfo.parse_cookie(cookieLang)) {
                throw std::runtime_error("cannot parse property cookie");
            }

            continue;
        }

        Napi::String headerValue = object.Get(headerName).As<Napi::String>();
        std::string value = headerValue.Utf8Value();

        if (!headerValue.IsString()) {
            continue;
        } else if (name == langdetect::strings::PARAM_GEO && !userInfo.parse_geo_regions(value)) {
            throw std::runtime_error("cannot parse property geo");
        } else if (name == langdetect::strings::PARAM_LANGUAGE && !userInfo.parse_accept_language(value)) {
            throw std::runtime_error("cannot parse property language");
        } else if (name == langdetect::strings::PARAM_DOMAIN && !userInfo.parse_host(value)) {
            throw std::runtime_error("cannot parse property domain");
        } else if ((name == langdetect::strings::PARAM_PASS_LANGUAGE || name == "passLanguage") && !userInfo.set_pass_language(value)) {
            throw std::runtime_error("cannot parse property passLanguage");
        } else if (name == langdetect::strings::PARAM_FILTER) {
            filter.add(value);
        } else if (name == langdetect::strings::PARAM_DEFAULT) {
            defaultLanguage = value;
        }
    }
}

}
