export type RegionId = number;

export interface Linguistics {
    ablative: string;
    accusative: string;
    dative: string;
    directional: string;
    genitive: string;
    instrumental: string;
    locative: string;
    nominative: string;
    preposition: string;
    prepositional: string;
}

export interface Region {
    id: RegionId;
    type: number;
    parent_id: number;
    name: string;
    latitude: number;
    longitude: number;
}

export interface IpTraits {
    region_id: RegionId;

    asn_list?: string;
    isp_name?: string;
    org_name?: string;

    hosting?: boolean;
    mobile?: boolean;
    proxy?: boolean;
    reserved?: boolean;
    stub_range?: boolean;
    tor?: boolean;
    vpn?: boolean;
    yandex_net?: boolean;
    yandex_staff?: boolean;
    yandex_turbo?: boolean;
}

// https://doc.yandex-team.ru/lib/libgeobase5/concepts/interfaces-cplusplus-structures.html#geolocation
export interface Geolocation {
    region_id: number;
    region_id_by_ip: number;
    precision_by_ip: number;
    suspected_region_id: number;
    precision: number;
    point_id: number;
    should_update_cookie: boolean;
    gid_is_trusted: boolean;
    location: GeolocationPos;
    region_id_by_gp: number;
}

export interface GeolocationPos {
    latitude: number;
    longitude: number;
}

// https://doc.yandex-team.ru/lib/libgeobase5/concepts/interfaces-cplusplus-structures.html#geolocation_search_data
export interface GeolocationSearchData {
    ip: string;
    yandex_gid: number;

    gpauto?: string;
    x_forwarded_for?: string;
    x_real_ip?: string;
    user_points?: string;
    override_point?: string;
    is_trusted?: boolean;
    allow_yandex?: boolean;
    disable_suspected_region?: boolean;
}

export class GeobaseLookup {
    constructor(path: string);

    getChildrenIds(id: RegionId): Array<RegionId>;
    getCountryRegion(id: RegionId): Region;
    getLinguistics(id: RegionId, locale: 'ru'): Linguistics;
    getParentsIds(id: RegionId): Array<RegionId>;
    getRegionById(id: RegionId): Region;
    getRegionByIp(ip: string): Region;
    getRegionIdByLocation(latitude: number, longitude: number): RegionId;
    getRegionsByType(type: number, domain?: string): Array<Region>;
    getTimezoneById(id: RegionId): string;
    getTraitsByIp(ip: string): IpTraits;
    isIdInRegion(id: number, pid: number, domain?: string): boolean;
    isIpInRegion(ip: string, pid: number, domain?: string): boolean;
    makePinpointGeolocation(search_data: GeolocationSearchData, yp_cookie: string, ys_cookie: string): Geolocation;
}
