export interface IFindOptions {
    geo?: string; // Id регионов пользователя через запятую
    language?: string | string[]; // Язык из поля Accept-Language заголовка HTTP запроса
    cookie?: string; // Язык из куки my
    domain?: string; // Домен
    filter?: string; // Перечень доступных языков через запятую
    'pass-language'?: string; // Язык из Паспорта
    default?: string; // Язык сервиса по умолчанию
}

export interface ILang {
    id: string;
    name: string;
}

export interface ILangdetect extends ILang {
    detector?: LangDetector;
    list?: ILang[];
}

export interface IFindDomainResponse {
    host: string;
    'content-region': number; // Регион пользователя
    changed: boolean; // true, если логикой библиотеки найден домен для переадресации
}

export declare class LangDetector {
    constructor(file: string);

    /* Местоположение файла lang-detect-data.txt */
    public find(options: IFindOptions): ILang | undefined;

    /* Определяет язык отображения страницы альтернативным алгоритмом, не учитывающим домен запроса */
    public findWithoutDomain(options: IFindOptions): ILang | undefined;

    /* Возвращает список релевантных пользователю языков */
    public list(options: IFindOptions): ILang[] | undefined;

    /* Возвращает домен и регион пользователя */
    public findDomain(
        parents: string,
        domains: string,
        hostname: string,
        crCookie: string
    ): IFindDomainResponse | undefined;

    /* Преобразует числовой идентификатор языка в строковый */
    public cookie2language(cookieLang: number): string | undefined;

    /* Преобразует строковый идентификатор языка в числовой */
    public language2cookie(lang: string): number | undefined;
}
