#include "first_line.h"

#include <mail/library/utf8/utf8.h>

namespace NNotSoLiteSrv::NFirstline::NLib {

int FindFirstLine(
    const MsgText& msg,
    const Subscription* s,
    std::string& fl,
    size_t max_size,
    bool isPeopleType) {

    if (!s) {
        return -1;
    }
    const MsgText* amsg = &msg;
    MsgText htmlmsg;
    SubscriptionHelper* ss = s->s;

    if (!ss) {
        return -1;
    }

    // first pre-process html, if present
    if (!ss->text_fl.get()) {
        return -1;
    }

    bool has_html = (*amsg->html() != 0);
    bool html_tr = false;
    if (has_html && ss->html_fl.get()) {
        std::string html(amsg->html());
        std::string o;

        if (ss->html_fl->execute(html, o, s->hi)) {
            return -1;
        }

        if (!o.empty()) {
            html.swap(o);
            html_tr = true;
        }
        if (html_tr) {
            amsg = &htmlmsg.fromHtml(html.c_str(), isPeopleType);
        }
    }

    // now process plain text

    // cut very long string
    std::string text = NUtil::Utf8ByteHead(amsg->text(), (1024 * 600));

    std::string o;
    bool text_tr = false;

    if (ss->text_fl->execute(text, o, s->hi)) {
        return -1;
    }
    if (!o.empty()) {
        text.swap(o);
        text_tr = true;
    }

    if (!text_tr && !html_tr) {
        fl.clear();
        return -1;   // both transformations yielded nothing
    }

    for (size_t i = 0; i < text.length(); i++) {
        if (iscntrl(text[i])) {
            text[i] = ' ';
        }
    }
    // strip excessive whitespace and newlines
    // trim to fit firstline in max_size bytes stripping on word boundary if necessary
    std::ostringstream os;
    std::istringstream is(text);
    size_t tsz = 0;

    std::string word;
    is >> word;
    tsz += word.size();
    if (tsz < max_size) {
        os << word;
    }

    while (is && (tsz < max_size)) {
        word.clear();
        is >> word;
        if (!word.empty()) {
            tsz += word.size() + 1;
            if (tsz < max_size) {
                os << " " << word;
            }
        }
    }

    fl = os.str();

    return 0;
}

} // namespace NNotSoLiteSrv::NFirstline::NLib
