#pragma once

#include <library/cpp/html/html5/parse.h>
#include <library/cpp/html/face/onchunk.h>
#include <library/cpp/html/storage/storage.h>
#include <library/cpp/html/face/event.h>
#include <library/cpp/html/face/parstypes.h>
#include <util/stream/mem.h>

#include <vector>
#include <string>
#include <set>
#include <locale>

#include <strings.h>

namespace NNotSoLiteSrv::NFirstline::NLib {

void Transform(
    TStringBuf text,
    bool premode,
    int quoteLevel,
    bool isPeopleType,
    TString& out);

class TTextFromHtmlExtractor : public IParserResult {
public:
    explicit TTextFromHtmlExtractor(bool isPeopleType)
        : IsPeopleType(isPeopleType)
    {
        ;
    }
    TString getText() const {
        return Out;
    }
private:
    THtmlChunk* OnHtmlChunk(const THtmlChunk& chunk) override;
    void HandleAttribute(const THtmlChunk& chunk);
    void HandleBreak(const THtmlChunk& chunk);
    void HandleNonBreakMarkup(const THtmlChunk& chunk);
    void HandleText(const THtmlChunk& chunk);

    bool IsPeopleType = false;
    TString Out;
    int QuoteLevel = 0;
    bool IsPremode = false;
};

TString ExtractTextFromHtmlPart(TStringBuf htmlPart, bool isPeopleType);

}  // namespace NNotSoLiteSrv::NFirstline::NLib
