#pragma once

#include "pcre.h"
#include "message_text.h"

#include <string>

namespace NNotSoLiteSrv::NFirstline::NLib {

#define OVECSIZE 30    /* should be a multiple of 3 */
#define MAX_RULE_NUMBER 300

class CFirstLine {
public:
    CFirstLine();
    ~CFirstLine();
    int FL_LoadRules(std::stringstream& ss);
    int FL_Find(const char * text, char * first_line, int buf_len) const;
private:
    int  _fl_regexp_ini();
    void _fl_regexp_destroy();
    int  _fl_regexp_match(const char * regexp, const char * str, int *pos1, int *pos2);
    int  _fl_add_rule(const char * str, int set, int sw);
    int  _fl_match(char * str, int rule_n, int rule_set, int& rest, int& rest_size) const;
    int  _fl_get_line(const char * text, int *text_pos, int text_len, char *line, int len) const;
    int  _fl_spaces(const char * text) const;

    const unsigned char * m_tables;
    int m_count1;
    int m_count2;
    int m_count3;
    int m_count4;

    pcre *m_rules1[MAX_RULE_NUMBER];  // quotation
    pcre *m_rules2[MAX_RULE_NUMBER];  // greeting
    pcre *m_rules3[MAX_RULE_NUMBER];  // ending
    pcre *m_rules4[MAX_RULE_NUMBER];  // LJ comments begin

    int  m_sw_rules[MAX_RULE_NUMBER];  // LJ rules type

};

int LegacyFindFirstLine(const MsgText& msg, std::string& fline, const std::string& rules);

}  // namespace NNotSoLiteSrv::NFirstline::NLib
