#include "http_parse.h"
#include "message_text.h"

#include <mail/butil/include/butil/StrUtils/utf8.h>

#include <string>
#include <set>
#include <memory>


namespace NNotSoLiteSrv::NFirstline::NLib {

class MsgTextPrivate {
public:
    virtual ~MsgTextPrivate() {}

    virtual const char* text() const { return ""; }
    virtual const char* html() const { return ""; }
};

namespace {

std::string sanitized_utf8_copy(const std::string& in) {
    std::string d;
    typedef std::string::const_iterator it_t;
    typedef std::back_insert_iterator<std::string> ot_t;
    it_t src(in.begin());
    it_t end(in.end());
    ot_t dst(std::back_inserter(d));
    while (src != end) {
        src = is_valid_utf8_char(src, end) ?
            copy_utf8_char(src, dst) :
            next_utf8_char(src, end);
    }
    return d;
}

} // namespace anonymous


class MsgHtml : public MsgTextPrivate {
public:
    MsgHtml(const char* html, bool isPeopleType)
        : html_(sanitized_utf8_copy(html))
        , IsPeopleType(isPeopleType)
    {
        ;
    }

    const char* html() const override {
        return html_.c_str();
    }

    const char* text() const override {
        if (text_.empty()) {
            text_ = ExtractTextFromHtmlPart({html_.c_str(), html_.size()}, IsPeopleType);
        }
        return text_.c_str();
    }
private:
    std::string html_;
    mutable std::string text_;
    bool IsPeopleType;
};

class MsgPlainText : public MsgTextPrivate {
public:
    MsgPlainText(const char* text)
        : text_(sanitized_utf8_copy(text))
    {
        ;
    }

    const char* html() const override { return ""; }
    const char* text() const override { return text_.c_str(); }

private:
    std::string text_;
};


const char* MsgText::text() const {
    return impl_->text();
}

const char* MsgText::html() const {
    return impl_->html();
}


MsgText::MsgText()
    : impl_(new MsgPlainText(""))
{
    ;
}

MsgText::~MsgText() {
    ;
}

MsgText& MsgText::fromHtml(const char* html, bool isPeopleType) {
    impl_.reset(new MsgHtml(html, isPeopleType));
    return *this;
}

MsgText& MsgText::fromText(const char* text) {
    impl_.reset(new MsgPlainText(text));
    return *this;
}

} // namespace NNotSoLiteSrv::NFirstline::NLib
