#pragma once

#include <array>
#include <string>
#include <memory>
#include <vector>
#include <iostream>
#include <sstream>

#include <library/cpp/regex/pcre/regexp.h>


namespace NNotSoLiteSrv::NFirstline::NLib {


struct PcreSettings {
    int matchLimitRecursion = 1000000;
};


static const PcreSettings* g_pcre_settings = 0;


class Pcre {
public:
    explicit Pcre()
        : re_(nullptr)
    {
        ;
    }
    virtual ~Pcre() {
        if (re_) {
            pcre_free(re_);
        }
    }

    int compile(const unsigned char* tableptr) {
        const char* err;
        int erroffset;

        if (!regex_.empty()) {
            re_ = pcre_compile(regex_.c_str(), options_, &err, &erroffset, tableptr);
        }

        return (re_ ? 0 : -1);
    }

    template<typename StringLike, size_t N>
    int exec(const StringLike& str, std::array<int, N>& vec) const {
        static_assert(N % 3 == 0, "ovector size must be a multiply of 3");
        pcre_extra pe;
        pe.flags = 0;

        if (g_pcre_settings && g_pcre_settings->matchLimitRecursion) {
            pe.flags = PCRE_EXTRA_MATCH_LIMIT_RECURSION;
            pe.match_limit_recursion = g_pcre_settings->matchLimitRecursion;
        }

        int count = pcre_exec(re_, &pe, str.data(), int(str.size()), 0, 0, vec.data(), int(vec.size()));

        if (count == PCRE_ERROR_NOMATCH) {
            count = 0;
        }

        if (count < 0) {
            std::ostringstream os;
            os << "pcre_exec in Pcre::exec returned " << count;
            throw std::runtime_error(os.str());
        }

        return count;
    }

public:
    std::string regex_;

protected:
    pcre *re_;
    int options_ = PCRE_CASELESS | PCRE_DOTALL | PCRE_UTF8 | PCRE_NO_UTF8_CHECK;
};

class Match: public Pcre {
public:

    int execute(const std::string& src) const {
        int rv;
        std::array<int, 30> vec;

        rv = exec(src, vec);

        return (rv == 0 ? -1 : 0);
    }
protected:
    int options_ = PCRE_CASELESS | PCRE_DOTALL | PCRE_UTF8;
};


} // namespace NNotSoLiteSrv::NFirstline::NLib
