#pragma once

#include "pcre.h"
#include "subject.h"
#include "rules.h"
#include "subscription_source.h"
#include "subscription_helper.h"

#include <string>
#include <vector>

namespace NNotSoLiteSrv::NFirstline::NLib {

class Subscription {
public:
    Subscription(SubscriptionHelper* sh, const std::string& subj)
        : s(sh)
        , hi(subj)
    {
        ;
    }
    SubscriptionHelper* s;
    MessageHeaderInfo hi;
};


std::unique_ptr<Subscription> CreateSubscription(
    const std::string& from_email,
    const std::string& from_text,
    const std::string& subjstr,
    const SubscriptionSource* v);

std::unique_ptr<Subscription> CreateSubscription(
    const std::string& service,
    const std::string& subjstr,
    const SubscriptionSource* v);

std::unique_ptr<Subscription> CreateSubscription_helper(
    const std::string& from_email,
    const std::string& from_text,
    const std::string& subjstr,
    const SubscriptionSource* v);

bool IsAuthorised(
    const Subscription* subscription,
    const char* authResults);

} // namespace NNotSoLiteSrv::NFirstline::NLib
