#pragma once

#include "subject.h"
#include "rules.h"

#include <string>
#include <vector>

namespace NNotSoLiteSrv::NFirstline::NLib {

struct From {
    std::string email;
    std::unique_ptr<Match> match;
};

using SmtpFrom = From;

using Froms = std::vector<std::unique_ptr<From>>;
using SmtpFroms = Froms;
using Labels = std::vector<std::unique_ptr<std::string>>;


struct SubscriptionHelper {
    explicit SubscriptionHelper()
        : auth(0)
    {
        ;
    }

    std::unique_ptr<std::string> service;
    Froms froms;
    SmtpFroms smtpfroms;
    std::unique_ptr<Subject> subject;
    std::unique_ptr<Rule> url;
    Labels labels;
    std::unique_ptr<Rule> text_fl;
    std::unique_ptr<Rule> html_fl;
    int auth; // is spf/dkim authorisation required for this subscription?
};


} // NNotSoLiteSrv::NFirstline::NLib
