#include "my_element.h"
#include "subscription_source.h"

#include <contrib/libs/expat/expat.h>

namespace NNotSoLiteSrv::NFirstline::NLib {

void XMLCALL
StartElement(void* userData, const char* name, const char** atts) {
    try {
        MyData* d = static_cast<MyData*>(userData);
        if (!d || !d->currEl)
            return;
        d->currEl->start(d, name, atts);
    } catch (...) {
        return;
    }
}

void XMLCALL
EndElement(void* userData, const char* /*name*/) {
    MyData* d = static_cast<MyData*>(userData);
    if (d && d->currEl) {
        d->currEl->end(d);
    }
}

void XMLCALL
CharacterDataHandler(void* userData, const XML_Char* _str, int len) {
    MyData* d = static_cast<MyData*>(userData);
    if (d && d->currEl) {
        d->currEl->character_data(_str, len);
        return;
    }
}

std::unique_ptr<SubscriptionSource> CreateSubscriptionSource(const char* filename, ui32 size) {
    std::unique_ptr<SubscriptionSource> v(new SubscriptionSource);
    std::unique_ptr<XML_ParserStruct, void(*)(XML_ParserStruct*)> parser(XML_ParserCreate(nullptr), XML_ParserFree);
    MyData data;
    data.v = v.get();
    v->tables = pcre_maketables();
    std::unique_ptr<RootEl> root(new RootEl);
    data.currEl = root.get();

    XML_SetUserData(parser.get(), &data);
    XML_SetElementHandler(parser.get(), StartElement, EndElement);
    XML_SetCharacterDataHandler(parser.get(), CharacterDataHandler);

    if (XML_Parse(parser.get(), filename, size, 1) == XML_STATUS_ERROR) {
        return 0;
    }

    // build "from"->subscription map, "service"->subscription map
    for (auto& sh: *v) {
        SubscriptionHelper* s = sh.get();
        for (auto& from: s->froms) {
            if (!from->email.empty()) {
                v->smap.insert(std::make_pair(from->email, s));
            }
        }
        if (s->service.get()) {
            v->smap.insert(std::make_pair(*s->service, s));
        }
    }

    return v;
}

} // NNotSoLiteSrv::NFirstline::NLib
