#pragma once

#include "pcre.h"
#include "subscription_helper.h"

#include <map>

namespace NNotSoLiteSrv::NFirstline::NLib {

class SubscriptionSource {
public:
    ~SubscriptionSource() {
        if (tables) {
            pcre_free(const_cast<unsigned char*>(tables));
        }
    }

    auto begin() const {
        return helpers_.begin();
    }

    auto end() const {
        return helpers_.end();
    }

    void push_back(SubscriptionHelper* s) {
        helpers_.emplace_back(s);
    }

    const unsigned char* tables = nullptr;
    std::multimap<std::string, SubscriptionHelper*> smap; // email -> subscription, service -> subscription
    std::unique_ptr<PcreSettings> pcre;

private:
    std::vector<std::unique_ptr<SubscriptionHelper>> helpers_;
};

std::unique_ptr<SubscriptionSource> CreateSubscriptionSource(const char* filename, ui32 size);

} // namespace NNotSoLiteSrv::NFirstline::NLib
