#pragma once

#include "strutils.h"

#include <mail/notsolitesrv/lib/mthr/src/ru_locale.h>

#include <mail/mimeparser/include/mimeparser/utf8.h>

#include <boost/algorithm/string/predicate.hpp>

#include <util/generic/string.h>
#include <util/generic/set.h>

namespace NMthr {

struct TMaxLengthCompare {
    bool operator()(const TString& lhs, const TString& rhs) const {
        if (lhs.size() == rhs.size()) {
            return lhs > rhs;
        }
        return lhs.size() > rhs.size();
    }
};

using TReFwTokens = TSet<TString, TMaxLengthCompare>;

const TReFwTokens FW_TOKENS{
    {"fwd"},
    {"fw"},
    {"wg"},
    {"ilt"},
    {"转发"}
};

const TReFwTokens RE_TOKENS{
    {"re"},
    {"aw"},
    {"ynt"},
    {"ha"},
    {"на"},
    {"vs"},
    {"答复"}
};


template <class ForwardIterator>
ForwardIterator LeftTrimLongestToken(
    ForwardIterator begin,
    ForwardIterator end,
    const TReFwTokens& tokens)
{
    using namespace mulca_mime;

    const auto iCaseCompare = boost::is_iequal(RU_UTF8_LOCALE);
    const auto utfBegin = make_utf8_ro_iterator(begin);
    const auto utfEnd = make_utf8_ro_iterator(end);

    for (const auto& token : tokens) {
        const auto utfTokenBegin = make_utf8_ro_iterator(token.begin());
        const auto utfTokenEnd = make_utf8_ro_iterator(token.end());

        const auto [left, right] = std::mismatch(utfBegin, utfEnd, utfTokenBegin, utfTokenEnd, iCaseCompare);

        if (std::equal(utfBegin, left, utfTokenBegin, utfTokenEnd, iCaseCompare)) {
            return left.base();
        }
    }
    return begin;
}

template <class ForwardIterator>
ForwardIterator RightTrimLongestToken(
    ForwardIterator begin,
    ForwardIterator end,
    const TReFwTokens& tokens)
{
    using namespace mulca_mime;

    const auto iCaseCompare = boost::is_iequal(RU_UTF8_LOCALE);
    const auto utfBegin = make_utf8_ro_iterator(begin);
    const auto utfEnd = make_utf8_ro_iterator(end);

    for (const auto& token : tokens) {
        const auto utfTokenBegin = make_utf8_ro_iterator(token.begin());
        const auto utfTokenEnd = make_utf8_ro_iterator(token.end());

        auto lastFound = std::find_end(utfBegin, utfEnd, utfTokenBegin, utfTokenEnd, iCaseCompare);

        if (std::equal(lastFound, utfEnd, utfTokenBegin, utfTokenEnd, iCaseCompare)) {
            return lastFound.base();
        }
    }
    return end;
}

} // namespace NMthr
