#pragma once

#include <algorithm>
#include <cctype>

namespace NMthr {

template <class Iterator>
Iterator LeftTrimWhiteSpaces(Iterator begin, Iterator end) {
    return std::find_if_not(begin, end, [](auto ch) {
        return std::isspace(ch);
    });
}

template <class Iterator>
Iterator RightTrimWhiteSpaces(Iterator begin, Iterator end) {
    auto revBegin = std::reverse_iterator<Iterator>(end);
    auto revEnd = std::reverse_iterator<Iterator>(begin);
    auto iter = LeftTrimWhiteSpaces(revBegin, revEnd);
    return end - (iter - revBegin);
}

} // namespace NMthr
