#include "fnv_hash.h"

#include <butil/StrUtils/utf8.h>

#include <util/generic/strbuf.h>

namespace NMthr {

ui64 CalcOracleFnv1HashFromUTF8(const TStringBuf& buffer) {
    ui64 result = 0xCBF29CE484222325;
    const ui64 prime = 0x100000001B3;
    const ui8* ptr = reinterpret_cast<const ui8*>(buffer.data());
    const ui8* const end = ptr + buffer.size();
    while (ptr < end) {
        const ui8* const last = next_utf8_char(ptr, end);
        ui64 value = *ptr++;
        while (ptr < last) {
            value <<= 8;
            value |= *ptr++;
        }
        result *= prime;
        result ^= value;
    }
    return result;
}

} // namespace NMthr
