#pragma once

#include "merge_rules.h"
#include "message_info.h"

#include <util/system/types.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

#include <ctime>

namespace NMthr {

constexpr ui32 DAYS_LIMIT = 90;
constexpr ui32 MAILS_LIMIT = 1000;

enum class EMergePolicy : ui8 {
    Hash = 0  /* "hash" */,
    References = 1  /* "references" */,
    ForceNew = 2  /* "force_new" */
};

enum class EHashNameSpace : ui8 {
    Subject = 0  /* "subject" */,
    From = 1 /* "from" */
};

struct TMailThreadHash {
    EHashNameSpace NameSpace = EHashNameSpace::Subject;
    ui64 Value = 0;
};

ui64 CalcHashFromLowerUTF8(const TStringBuf& buf);

TMailThreadHash CalcMailThreadHash(const TMessageInfo& msgInfo, const TMergeRule& mergeRule);

struct TMailThreadLimits {
    TMailThreadLimits()
        : TMailThreadLimits(DAYS_LIMIT, MAILS_LIMIT)
    {}
    TMailThreadLimits(ui32 daysLimit, ui32 countLimit)
        : DaysLimit(DAYS_LIMIT)
        , CountLimit(MAILS_LIMIT)
    {
        if (daysLimit > 0) {
            DaysLimit = daysLimit;
        }
        if (countLimit > 0) {
            CountLimit = countLimit;
        }
    }

    ui32 DaysLimit;
    ui32 CountLimit;
};

struct TMailThreadInfo {
    TMailThreadHash Hash;
    TMailThreadLimits Limits;
    EMergePolicy MergePolicy = EMergePolicy::ForceNew;
    ui32 MergeRuleId = TMergeRule::DEFAULT_ID;

    TVector<ui64> ReferenceHashes;
    TVector<TString> MessageIds;
    ui64 InReplyToHash = 0;
    ui64 MessageIdHash = 0;

    void SetReferenceHashes(const TVector<TString>& msgIds);
};

TMergeRule FindMergeRuleSafe(
    const TMessageInfo& msgInfo,
    const TMergeRules& mergeRules,
    const TSet<std::string>& experiments = TSet<std::string>());

TMailThreadInfo CalcMailThreadInfo(
    const TMessageInfo& msgInfo,
    const TMergeRule& mergeRule);

} // namespace NMthr
