#pragma once

#include <mail/message_types/lib/message_types.h>
#include <mail/notsolitesrv/lib/mthr/src/reflection/merge_rules.h>

#include <library/cpp/json/json_reader.h>
#include <util/generic/vector.h>
#include <util/generic/string.h>
#include <util/generic/set.h>
#include <util/generic/maybe.h>
#include <util/generic/hash_set.h>

#include <set>
#include <string>

namespace NMthr {

struct TMergeRule {
    bool operator>(const TMergeRule& rhs) const {
        return Priority > rhs.Priority;
    }
    static const ui32 DEFAULT_ID = 0;

    ui32 Id = DEFAULT_ID;
    ui32 Priority = 0;

    std::string Field;
    ui32 RotateDays = 0;
    ui32 RotateMails = 0;

    TSet<std::string> MsgLabels;
    TSet<NMail::EMessageType> MsgTypes;
    TSet<std::string> Experiments;
    TMaybe<bool> IsTrivial;
};

TMergeRule MakeMergeRule(TOriginalMergeRule originalMergeRule);
TVector<TMergeRule> ReadMergeRulesFromJson(const std::string& json);
TVector<TString> ReadTrivialSubjectsFromJson(const std::string& json);

class TMergeRules {
public:
    using TCont = TVector<TMergeRule>;
    using TConstIterator = TCont::const_iterator;

    TMergeRules() = default;
    TMergeRules(
        const TVector<TMergeRule>& mergeRules,
        const TVector<TString>& trivialSubjects);

    TConstIterator end() const;

    TConstIterator find(
        const TStringBuf& baseSubject,
        const std::string& label,
        const TSet<NMail::EMessageType>& msgTypes,
        const TSet<std::string>& experiments) const;

private:
    bool IsSubjectTrivial(const TStringBuf& subject) const;

    bool MatchBySubject(
        const TMergeRule& rule,
        const TStringBuf& subject) const;

    static bool MatchByMsgLabel(
        const TMergeRule& rule,
        const std::string& msgLabel);

    static bool MatchByMsgTypes(
        const TMergeRule& rule,
        const TSet<NMail::EMessageType>& msgTypes);

    static bool MatchByExperiments(
        const TMergeRule& rule,
        const TSet<std::string>& experiments);

    TCont Rules;
    THashSet<TString> TrivialSubjects;
};

} // namespace NMthr
