#include "util.h"
#include <butil/StrUtils/utf8.h>
#include <util/generic/string.h>

namespace NMthr {

TString SanitizeUTF8(const TStringBuf& buffer) {
    TString res;
    auto out = std::back_inserter(res);
    auto begin = buffer.begin();
    auto end = buffer.end();
    while (begin != end) {
        if (is_valid_utf8_char(begin, end)) {
            begin = copy_utf8_char(begin, out);
        } else {
            begin = next_utf8_char(begin, end);
        }
    }
    return res;
}

} // namespace NMthr
