#pragma once

#include <util/generic/maybe.h>
#include <util/generic/set.h>
#include <util/generic/strbuf.h>
#include <util/generic/string.h>

#include <algorithm>
#include <iterator>
#include <optional>
#include <utility>
#include <vector>

namespace NMthr {

TString SanitizeUTF8(const TStringBuf& buffer);

template<typename Type> TMaybe<Type> MakeMaybe(const std::optional<Type>& value) {
    if (!value) {
        return {};
    }

    return {*value};
}

template<typename DstType, typename SrcType> TSet<DstType> MakeSet(
    const std::optional<std::vector<SrcType>>& range)
{
    if (!range) {
        return {};
    }

    TSet<DstType> result;
    auto transformer = [](const auto& value){return static_cast<DstType>(value);};
    std::transform(range->begin(), range->end(), std::inserter(result, result.end()), std::move(transformer));
    return result;
}

template<typename DstType, typename SrcType> TSet<DstType> MakeSet(
    std::optional<std::vector<SrcType>>&& range)
{
    if (!range) {
        return {};
    }

    TSet<DstType> result;
    auto transformer = [](auto&& value){return static_cast<DstType&&>(std::move(value));};
    std::transform(std::make_move_iterator(range->begin()), std::make_move_iterator(range->end()),
        std::inserter(result, result.end()), std::move(transformer));
    return result;
}

}
