#include <mail/notsolitesrv/lib/mthr/src/base_subject/base_subject.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/gtest.h>
#include <util/generic/strbuf.h>

using namespace NMthr;

TEST(FindBaseSubject, TestWhiteSpaces) {
    EXPECT_EQ(FindBaseSubject(""), "");
    EXPECT_EQ(FindBaseSubject("     "), "");
    EXPECT_EQ(FindBaseSubject("subj\n"), "subj");
    EXPECT_EQ(FindBaseSubject("subj\t\n"), "subj");
}

TEST(FindBaseSubject, TestIgnoreCase) {
    EXPECT_EQ(FindBaseSubject("subj  (fwD)"), "subj");
}

TEST(FindBaseSubject, TestSubjTrailer) {
    EXPECT_EQ(FindBaseSubject("subj{fwd}"), "subj{fwd}");
    EXPECT_EQ(FindBaseSubject("subj(fwd)"), "subj");
    EXPECT_EQ(FindBaseSubject("(fw) subj (fwd)"), "subj");
}

TEST(FindBaseSubject, TestSubjBlob) {
    EXPECT_EQ(FindBaseSubject("[blob] subj"), "subj");
    EXPECT_EQ(FindBaseSubject(" [subj-blob] subj(fwd)\t\n"), "subj");
    EXPECT_EQ(FindBaseSubject("[subj-blob[] subj"), "[subj-blob[] subj");
}

TEST(FindBaseSubject, TestSubjFwd) {
    EXPECT_EQ(FindBaseSubject("[  fwd: subj]"), "subj");
}

TEST(FindBaseSubject, TestSubjReFwd) {
    EXPECT_EQ(FindBaseSubject("re: subj"), "subj");
    EXPECT_EQ(FindBaseSubject("re(32):  subj"), "subj");
    EXPECT_EQ(FindBaseSubject("Re[32]: subj"), "subj");
    EXPECT_EQ(FindBaseSubject("re{32}: subj"), "subj");
    EXPECT_EQ(FindBaseSubject("re{32]: subj"), "re{32]: subj");
    EXPECT_EQ(FindBaseSubject("fwd: re[12]: subj"), "subj");
}

TEST(FindBaseSubject, TestSubjLeader) {
    EXPECT_EQ(FindBaseSubject("[subj-blob] re [subj-blob] : subj"), "subj");
    EXPECT_EQ(FindBaseSubject("[subj-blob] fwd: subj"), "subj");
}

TEST(FindBaseSubject, TestComplexCases) {
    EXPECT_EQ(FindBaseSubject("(Fwd) re[2]: subj"), "subj");
    EXPECT_EQ(FindBaseSubject("FW: FWD: [8] RE: [12] [list] List: (Re: subj) (fwd)"), "List: (Re: subj)");
    EXPECT_EQ(FindBaseSubject(" re(4) [a]  [b]    [c]: subj   (fwd) "), "subj");
    EXPECT_EQ(FindBaseSubject(" Aw(5): WG: 转发: subj"), "subj");
    EXPECT_EQ(FindBaseSubject("HA: Re: subj"), "subj");
    EXPECT_EQ(FindBaseSubject("на: subj"), "subj");
    EXPECT_EQ(FindBaseSubject("VS: HA: На: сабж (FWD)"), "сабж");
    EXPECT_EQ(FindBaseSubject("revs: subj"), "revs: subj");
}

/**
 * We left this bug for compatibility reasons.
 * Hashes taken from base subject are stored in xdb, so fixing the algorithm
 * could break threading of new and old messages.
 */
TEST(FindBaseSubject, TestBugExistsInCurrentImplementation) {
    EXPECT_NE(FindBaseSubject("[fwd: [abc] re: subj (fwd)]"), "subj");
    EXPECT_EQ(FindBaseSubject("[fwd: [abc] re: subj (fwd)]"), "subj (fwd)");
}
