#include "fnv_hash.h"

#include <util/digest/fnv.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/gtest.h>

using namespace NMthr;


TEST(FnvHash, TestOldAndNewImplsResultInSameHashes) {
    EXPECT_EQ(CalcOracleFnv1HashFromUTF8(""), 0xCBF29CE484222325ULL);
    EXPECT_EQ(CalcOracleFnv1HashFromUTF8("a"), 0xAF63BD4C8601B7BEULL);
    EXPECT_EQ(CalcOracleFnv1HashFromUTF8("foo"), 0xD8CBC7186BA13533ULL);
    EXPECT_EQ(CalcOracleFnv1HashFromUTF8("foobar"), 0x340D8765A4DDA9C2ULL);
    EXPECT_EQ(CalcOracleFnv1HashFromUTF8("chongo was here!\n"), 0xE0ACA20B624E4235ULL);
    EXPECT_EQ(CalcOracleFnv1HashFromUTF8("curds and whey\n"), 0xF7045B3102B8906EULL);
    EXPECT_EQ(CalcOracleFnv1HashFromUTF8("\x54\x4e\x51\x40"), 0x7691FD7E028F6754ULL);
    EXPECT_EQ(CalcOracleFnv1HashFromUTF8("127.0.0.1"), 0x34AD3B1041204318ULL);
    EXPECT_EQ(CalcOracleFnv1HashFromUTF8("64.81.78.84"), 0x02A184BCA4AA3ED5ULL);
    EXPECT_EQ(CalcOracleFnv1HashFromUTF8("line 1\nline 2\nline 3"), 0xA64E5F36C9E2B0E3ULL);
    EXPECT_EQ(CalcOracleFnv1HashFromUTF8("chongo <Landon Curt Noll> /\\../\\"), 0x8FD0680DA3088A04ULL);
    EXPECT_EQ(CalcOracleFnv1HashFromUTF8("http://antwrp.gsfc.nasa.gov/apod/astropix.html"), 0xCB27F4B8E1B6CC20ULL);
}
