#include <mail/notsolitesrv/lib/mthr/src/message_id.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/gtest.h>

using namespace NMthr;

TEST(IsValidMessageId, Simple) {
    EXPECT_TRUE(IsValidMessageId("<foo@bar.com>"));
}

TEST(IsValidMessageId, SimpleSubDomain) {
    EXPECT_TRUE(IsValidMessageId("<foo@buz.bar.com>"));
}

TEST(IsValidMessageId, Empty) {
    EXPECT_FALSE(IsValidMessageId(""));
}

TEST(IsValidMessageId, NoAt) {
    EXPECT_FALSE(IsValidMessageId("<foobar.com>"));
}

TEST(IsValidMessageId, NoAtSubDomain) {
    EXPECT_FALSE(IsValidMessageId("<foo.bar.com>"));
}

TEST(IsValidMessageId, NoBrackets) {
    EXPECT_FALSE(IsValidMessageId("<foobar.com"));
    EXPECT_FALSE(IsValidMessageId("foobar.com>"));
    EXPECT_FALSE(IsValidMessageId("foobar.com"));
    EXPECT_FALSE(IsValidMessageId("foo@bar.com"));
}
