#include <mail/notsolitesrv/lib/mthr/src/base_subject/refw_tokens.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/gtest.h>
#include <util/generic/strbuf.h>

using namespace NMthr;

TEST(LeftTrimLongestToken, SimpleTest) {
    TStringBuf text = "foo: subj";
    auto iter = LeftTrimLongestToken(text.begin(), text.end(), {{"fwd"}});
    EXPECT_EQ(iter, text.begin());

    text = "fwd: subj";
    iter = LeftTrimLongestToken(text.begin(), text.end(), {{"fwd"}});
    EXPECT_EQ(TString(iter, text.end()), ": subj");
}

TEST(LeftTrimLongestToken, IgnoreCase) {
    TStringBuf text = "fWd: subj";
    auto iter = LeftTrimLongestToken(text.begin(), text.end(), {{"fwd"}});
    EXPECT_EQ(TString(iter, text.end()), ": subj");
}

TEST(LeftTrimLongestToken, MatchLongest) {
    TStringBuf text = "fwd: subj";
    auto iter = LeftTrimLongestToken(text.begin(), text.end(), {{"fwd"}, {"fw"}});
    EXPECT_EQ(TString(iter, text.end()), ": subj");
}

TEST(LeftTrimLongestToken, NonASCIICodePoint) {
    TStringBuf text = "答复: subj";
    auto iter = LeftTrimLongestToken(text.begin(), text.end(), {{"答复"}});
    EXPECT_EQ(TString(iter, text.end()), ": subj");
}

TEST(RightTrimLongestToken, SimpleTest) {
    TStringBuf text = "subj foo";
    auto iter = RightTrimLongestToken(text.begin(), text.end(), {{"fwd"}});
    EXPECT_EQ(iter, text.end());

    text = "subj fwd";
    iter = RightTrimLongestToken(text.begin(), text.end(), {{"fwd"}});
    EXPECT_EQ(TString(text.begin(), iter), "subj ");
}

TEST(RightTrimLongestToken, IgnoreCaseNonASCIICodePoint) {
    TStringBuf text = "subj (НА";
    for (auto token : {"На", "нА", "на", "НА"}) {
        auto iter = RightTrimLongestToken(text.begin(), text.end(), {token});
        EXPECT_EQ(TString(text.begin(), iter), "subj (");
    }
}
