#include <mail/notsolitesrv/lib/mthr/src/util.h>

#include <library/cpp/testing/unittest/gtest.h>

#include <cstdint>
#include <optional>
#include <vector>

using NMthr::MakeSet;
using NMthr::SanitizeUTF8;

TEST(Util, SanitizeUTF8) {
    EXPECT_EQ(SanitizeUTF8(""), "");
    EXPECT_EQ(SanitizeUTF8("abc"), "abc");
    EXPECT_EQ(SanitizeUTF8("\xff"), "");
    EXPECT_EQ(SanitizeUTF8("\xff\xfe"), "");
    EXPECT_EQ(SanitizeUTF8("\x00\x00"), "");
    EXPECT_EQ(SanitizeUTF8("\xcf\xf0\xe8\xe2\xe5\xf2"), "");
    EXPECT_EQ(SanitizeUTF8("a\xcf"), "a");
    EXPECT_EQ(SanitizeUTF8("\xcf\x61"), "a");
}

TEST(Util, MakeMaybe) {
    using TOptional = std::optional<int>;
    EXPECT_FALSE(NMthr::MakeMaybe(TOptional{}));
    const auto value{3};
    const auto maybe{NMthr::MakeMaybe(TOptional{value})};
    EXPECT_TRUE(maybe);
    EXPECT_TRUE(value == *maybe);
}

TEST(Util, MakeSet) {
    using TRange = std::optional<std::vector<int>>;
    TRange range;
    EXPECT_FALSE(MakeSet<uint32_t>(range));
    EXPECT_FALSE(MakeSet<uint32_t>(TRange{}));
    range = {2, 0, 1, 1, 2};
    EXPECT_EQ((TSet<uint32_t>{0, 1, 2}), MakeSet<uint32_t>(range));
    EXPECT_EQ((TSet<uint32_t>{3, 4, 5}), MakeSet<uint32_t>(TRange{{5, 3, 4, 4, 5}}));
}
