#!/bin/bash

security_url="http://admin-api.sq2.yandex.ru/monitoring/?uids=1"
draft_file="/app/resources/related_uids"

(
if ! flock -xn 201; then
    echo "Can't acquire lock"
    exit 0
fi

# add security aliases
curl  --connect-timeout 5 -s $security_url | grep -v ^$ | awk -F \; '{aliases[$1] = aliases[$1] " " $2} END {for (uids in aliases) {aliases[uids] = uids aliases[uids]; print aliases[uids]}}' | sort > $draft_file.tmp

if [[ -s $draft_file.tmp ]] ; then
    cmp $draft_file $draft_file.tmp > /dev/null 2>&1
    if [[ $? -eq 1 ]] ; then
        cat $draft_file.tmp > $draft_file
        rm $draft_file.tmp
        logger -t get_related_uids -p daemon.info 'reload notsolitesrv due to new related uids'
        workload_signal app SIGHUP
    fi
else
    echo "Can't make $draft_file.tmp"
    rm -f $draft_file.tmp
    exit 1
fi

) 201>/var/run/related_uids.lock
